<a name="3.5.0"></a>
# [3.5.0](https://github.com/mengxiong10/vue2-datepicker/compare/v3.4.1...v3.5.0) (2020-04-22)


### Features

* add argument `event` for `open` event ([#457](https://github.com/mengxiong10/vue2-datepicker/issues/457)) ([a4103fa](https://github.com/mengxiong10/vue2-datepicker/commit/a4103fa))
* add type for `calendar-change` ([#459](https://github.com/mengxiong10/vue2-datepicker/issues/459)) ([c835c79](https://github.com/mengxiong10/vue2-datepicker/commit/c835c79))



<a name="3.4.1"></a>
## [3.4.1](https://github.com/mengxiong10/vue2-datepicker/compare/v3.4.0...v3.4.1) (2020-03-06)


### Bug Fixes

* split error when rangeSeparator is same as token ([435a6e8](https://github.com/mengxiong10/vue2-datepicker/commit/435a6e8))



<a name="3.4.0"></a>
# [3.4.0](https://github.com/mengxiong10/vue2-datepicker/compare/v3.3.1...v3.4.0) (2020-03-06)


### Bug Fixes

* fix open event fired multiple times ([be26d2a](https://github.com/mengxiong10/vue2-datepicker/commit/be26d2a))
* mobile support for date range ([#419](https://github.com/mengxiong10/vue2-datepicker/issues/419)) ([3c2e00e](https://github.com/mengxiong10/vue2-datepicker/commit/3c2e00e))
* popup doesn't reposition when scrolling in Firefox ([#427](https://github.com/mengxiong10/vue2-datepicker/issues/427)) ([2d50e75](https://github.com/mengxiong10/vue2-datepicker/commit/2d50e75))


### Features

* add `calendar-change` event ([#432](https://github.com/mengxiong10/vue2-datepicker/issues/432)) ([17d2262](https://github.com/mengxiong10/vue2-datepicker/commit/17d2262))
* add `pick` event when date clicked ([#429](https://github.com/mengxiong10/vue2-datepicker/issues/429)) ([2fb9e67](https://github.com/mengxiong10/vue2-datepicker/commit/2fb9e67))
* ignore whitespace around separator on manual range input ([#416](https://github.com/mengxiong10/vue2-datepicker/issues/416)) ([376a7ef](https://github.com/mengxiong10/vue2-datepicker/commit/376a7ef))



<a name="3.3.1"></a>
## [3.3.1](https://github.com/mengxiong10/vue2-datepicker/compare/v3.3.0...v3.3.1) (2020-02-18)


### Bug Fixes

* adjust zIndex of popup ([#412](https://github.com/mengxiong10/vue2-datepicker/issues/412)) ([513d10a](https://github.com/mengxiong10/vue2-datepicker/commit/513d10a))
* change  z-index to style variable ([#412](https://github.com/mengxiong10/vue2-datepicker/issues/412)) ([82080aa](https://github.com/mengxiong10/vue2-datepicker/commit/82080aa))



<a name="3.3.0"></a>
# [3.3.0](https://github.com/mengxiong10/vue2-datepicker/compare/v3.2.2...v3.3.0) (2019-12-19)


### Bug Fixes

* `get-class` should be valid in `range` ([c8f7122](https://github.com/mengxiong10/vue2-datepicker/commit/c8f7122))
* shortcus with range ([#400](https://github.com/mengxiong10/vue2-datepicker/issues/400)) ([bb0255f](https://github.com/mengxiong10/vue2-datepicker/commit/bb0255f))


### Features

* `default-value` supports Array for `range` ([#395](https://github.com/mengxiong10/vue2-datepicker/issues/395)) ([b33c9b8](https://github.com/mengxiong10/vue2-datepicker/commit/b33c9b8))
* add `prefixClass` prop ([#401](https://github.com/mengxiong10/vue2-datepicker/issues/401)) ([a756753](https://github.com/mengxiong10/vue2-datepicker/commit/a756753))
* add prop `defaultPanel` ([#394](https://github.com/mengxiong10/vue2-datepicker/issues/394)) ([73a1b73](https://github.com/mengxiong10/vue2-datepicker/commit/73a1b73))



<a name="3.2.2"></a>
## [3.2.2](https://github.com/mengxiong10/vue2-datepicker/compare/v3.2.1...v3.2.2) (2019-12-05)


### Bug Fixes

* prevent button triggering external form submit ([#389](https://github.com/mengxiong10/vue2-datepicker/issues/389)) ([7fcc1df](https://github.com/mengxiong10/vue2-datepicker/commit/7fcc1df))
* prop `lang` should be reactive ([#391](https://github.com/mengxiong10/vue2-datepicker/issues/391)) ([3c76fc3](https://github.com/mengxiong10/vue2-datepicker/commit/3c76fc3))



<a name="3.2.1"></a>
## [3.2.1](https://github.com/mengxiong10/vue2-datepicker/compare/v3.2.0...v3.2.1) (2019-12-03)


### Bug Fixes

* `defaultValue` should be used in datetime mode ([#384](https://github.com/mengxiong10/vue2-datepicker/issues/384)) ([309a1bf](https://github.com/mengxiong10/vue2-datepicker/commit/309a1bf))



<a name="3.2.0"></a>
# [3.2.0](https://github.com/mengxiong10/vue2-datepicker/compare/v3.1.1...v3.2.0) (2019-12-02)


### Bug Fixes

* can't clear input box ([52bd1fe](https://github.com/mengxiong10/vue2-datepicker/commit/52bd1fe))


### Features

* add `getWeek` in custom format ([#382](https://github.com/mengxiong10/vue2-datepicker/issues/382)) ([4d935d7](https://github.com/mengxiong10/vue2-datepicker/commit/4d935d7))
* add the second parameter to `disabled-date` ([#385](https://github.com/mengxiong10/vue2-datepicker/issues/385)) ([da2ac23](https://github.com/mengxiong10/vue2-datepicker/commit/da2ac23))



<a name="3.1.1"></a>
## [3.1.1](https://github.com/mengxiong10/vue2-datepicker/compare/v3.1.0...v3.1.1) (2019-11-25)


### Bug Fixes

* panel doesn't close after picking time ([#378](https://github.com/mengxiong10/vue2-datepicker/issues/378)) ([8657d49](https://github.com/mengxiong10/vue2-datepicker/commit/8657d49))
* when custom formatting causes the time-panel error ([#377](https://github.com/mengxiong10/vue2-datepicker/issues/377)) ([bf949af](https://github.com/mengxiong10/vue2-datepicker/commit/bf949af))



<a name="3.1.0"></a>
# [3.1.0](https://github.com/mengxiong10/vue2-datepicker/compare/v3.0.2...v3.1.0) (2019-11-21)


### Bug Fixes

*  ie style compatible ([e69b9b7](https://github.com/mengxiong10/vue2-datepicker/commit/e69b9b7))
* move sidebar element to right position ([32c74a4](https://github.com/mengxiong10/vue2-datepicker/commit/32c74a4))


### Features

* add slot `input` ([ffd3918](https://github.com/mengxiong10/vue2-datepicker/commit/ffd3918))
* export the scss for custom style ([09a4d8f](https://github.com/mengxiong10/vue2-datepicker/commit/09a4d8f))



<a name="3.0.2"></a>

## [3.0.2](https://github.com/mengxiong10/vue2-datepicker/compare/v3.0.1...v3.0.2) (2019-11-14)

### Bug Fixes

- compatible with vue old version inject ([c03632f](https://github.com/mengxiong10/vue2-datepicker/commit/c03632f))
- should return `[null, null]` when clear a range ([635631f](https://github.com/mengxiong10/vue2-datepicker/commit/635631f))
- when year < 100 && year >= 0, the date should be right ([8c546cc](https://github.com/mengxiong10/vue2-datepicker/commit/8c546cc))

### Features

- add prop `partial-update`. It'll update the date when select year or month in `type='date'` or `type='datetime'` ([07f4271](https://github.com/mengxiong10/vue2-datepicker/commit/07f4271))

<a name="3.0.1"></a>

## [3.0.1](https://github.com/mengxiong10/vue2-datepicker/compare/v3.0.0...v3.0.1) (2019-11-11)

### Bug Fixes

- fix clear event not triggering ([#369](https://github.com/mengxiong10/vue2-datepicker/issues/369)) ([06e158e](https://github.com/mengxiong10/vue2-datepicker/commit/06e158e))
- ie compatibility ([99a4abd](https://github.com/mengxiong10/vue2-datepicker/commit/99a4abd))

<a name="3.0.0"></a>

# [3.0.0](https://github.com/mengxiong10/vue2-datepicker/compare/v3.0.0-beta.1...v3.0.0) (2019-11-10)

### Bug Fixes

- localization (lang) is not used for date formatting

### Features

- Add week picker
  ```html
  <date-picer type="week" />
  ```
- Add inline calendar without input

  ```html
  <date-picker inline />
  ```

- Add prop `open` to control the state of popup
- Add select am/pm, when use12hours
- Add event `open` and `close`
- Add `hourStep`/`minuteStep`/`secondStep`/`showHour`/`showMinute`/`showSecond`/`use12h` to time picker for more configuration

### Breaking changes

- Need to import style separately
- Change the default language to English. And need to import file to change the language.
- Range selection refactoring, you can select a range on one calendar now, and need to click twice to select a range each time.
- Change slot `calendar-icon` to `icon-calendar`.
- `appendToBody` default value changes from false to true.
- Remove `not-before` and `not-after`, use `disabledDate` instead.

  ```html
  <template>
    <date-picker :disabled-date="notBeforeToday"></date-picker>
    <date-picker :disabled-date="notAfterToday"></date-picker>
  </template>
  <script>
    export default {
      methods: {
        notBeforeToday(date) {
          const today = new Date();
          today.setHours(0, 0, 0, 0);
          return date.getTime() < today.getTime();
        },
        notAfterToday(date) {
          const today = new Date();
          today.setHours(0, 0, 0, 0);
          return date.getTime() > today.getTime();
        },
      },
    };
  </script>
  ```

- Remove `width`, use `style="{ width: "" }"` instead.
- modify `shortcuts` api.

  ```js
  [
    { text: 'today', onClick: () => new Date() // return a Date }
  ];

  ```

- Remove prop `firstDayOfWeek` to locale.

## [2.13.3](https://github.com/mengxiong10/vue2-datepicker/compare/v2.13.2...v2.13.3) (2019-10-29)

### Bug Fixes

- defaultValue should update calendar ([#364](https://github.com/mengxiong10/vue2-datepicker/issues/364)) ([5e463bd](https://github.com/mengxiong10/vue2-datepicker/commit/5e463bd3cf973b5257a58810f980c46e26824426))

## [2.13.2](https://github.com/mengxiong10/vue2-datepicker/compare/v2.13.1...v2.13.2) (2019-10-23)

### Bug Fixes

- compatible with mobile click events ([#334](https://github.com/mengxiong10/vue2-datepicker/issues/334)) ([57d57fc](https://github.com/mengxiong10/vue2-datepicker/commit/57d57fc645d670e88c60141d2238066c2ed1ce8f))
- fix the ro language ([43c59e6](https://github.com/mengxiong10/vue2-datepicker/commit/43c59e6b40ac71dd9ea988d0b51269e99dff7b22))

## [2.13.1](https://github.com/mengxiong10/vue2-datepicker/compare/v2.13.0...v2.13.1) (2019-10-22)

### Bug Fixes

- fix the Spanish Language error ([#361](https://github.com/mengxiong10/vue2-datepicker/issues/361)) ([04e1032](https://github.com/mengxiong10/vue2-datepicker/commit/04e10328eabfac6e10fe4a49e7579f2eff7a1736))

# [2.13.0](https://github.com/mengxiong10/vue2-datepicker/compare/v2.12.0...v2.13.0) (2019-10-14)

### Bug Fixes

- removed keyboard event `stopPropagation` ([864ab83](https://github.com/mengxiong10/vue2-datepicker/commit/864ab835ca93322eb103fa1e00770976b7d95c41))
- the clickoutside don't work sometimes ([#326](https://github.com/mengxiong10/vue2-datepicker/issues/326)) ([d9619f8](https://github.com/mengxiong10/vue2-datepicker/commit/d9619f815c6a87052b353b800c7e597a8dea816a))

### Features

- add prop `icon-day` to set calendar icon day ([62c3d60](https://github.com/mengxiong10/vue2-datepicker/commit/62c3d60dd93c15a3c3c8d433836f3bb364d30bb7))

# [2.12.0](https://github.com/mengxiong10/vue2-datepicker/compare/v2.11.2...v2.12.0) (2019-06-25)

### Features

- add the prop `time-select-options` ([#227](https://github.com/mengxiong10/vue2-datepicker/issues/227)) ([a55b4b6](https://github.com/mengxiong10/vue2-datepicker/commit/a55b4b6))

## [2.11.2](https://github.com/mengxiong10/vue2-datepicker/compare/v2.11.1...v2.11.2) (2019-05-15)

### Bug Fixes

- fecha.parse invalid return false ([#309](https://github.com/mengxiong10/vue2-datepicker/issues/309)) ([96812ab](https://github.com/mengxiong10/vue2-datepicker/commit/96812ab))
- remove last shortcut "|" ([c6a6300](https://github.com/mengxiong10/vue2-datepicker/commit/c6a6300))
- test suites in another timezone failed ([#300](https://github.com/mengxiong10/vue2-datepicker/issues/300)) ([ec69590](https://github.com/mengxiong10/vue2-datepicker/commit/ec69590))

## [2.11.1](https://github.com/mengxiong10/vue2-datepicker/compare/v2.11.0...v2.11.1) (2019-04-30)

### Bug Fixes

- close popup after select shortcuts ([5823f85](https://github.com/mengxiong10/vue2-datepicker/commit/5823f85))

# [2.11.0](https://github.com/mengxiong10/vue2-datepicker/compare/v2.10.3...v2.11.0) (2019-04-09)

### Bug Fixes

- clickoutside bad when use append-to-body ([#291](https://github.com/mengxiong10/vue2-datepicker/issues/291)) ([9bb6046](https://github.com/mengxiong10/vue2-datepicker/commit/9bb6046))

### Features

- `select-year` and `select-month` ([#290](https://github.com/mengxiong10/vue2-datepicker/issues/290)) ([20d1f19](https://github.com/mengxiong10/vue2-datepicker/commit/20d1f19))

## [2.10.3](https://github.com/mengxiong10/vue2-datepicker/compare/v2.10.2...v2.10.3) (2019-03-14)

### Bug Fixes

- type input don't change the value ([#266](https://github.com/mengxiong10/vue2-datepicker/issues/266)) ([aa20a1e](https://github.com/mengxiong10/vue2-datepicker/commit/aa20a1e))

## [2.10.2](https://github.com/mengxiong10/vue2-datepicker/compare/v2.10.1...v2.10.2) (2019-03-14)

### Bug Fixes

- pick minute will affect the hour ([#168](https://github.com/mengxiong10/vue2-datepicker/issues/168)) ([2afed88](https://github.com/mengxiong10/vue2-datepicker/commit/2afed88))
- remove the append background ([e7775d6](https://github.com/mengxiong10/vue2-datepicker/commit/e7775d6))

### Performance Improvements

- remove IE 10's clear button X ([6a990d8](https://github.com/mengxiong10/vue2-datepicker/commit/6a990d8))

## [2.10.1](https://github.com/mengxiong10/vue2-datepicker/compare/v2.10.0...v2.10.1) (2019-03-11)

### Performance Improvements

- change the entity name to entity number ([dbbba6b](https://github.com/mengxiong10/vue2-datepicker/commit/dbbba6b))

# [2.10.0](https://github.com/mengxiong10/vue2-datepicker/compare/v2.9.2...v2.10.0) (2019-02-12)

### Features

- add prop `default-value` for calendar default date ([#94](https://github.com/mengxiong10/vue2-datepicker/issues/94)) ([4ff6945](https://github.com/mengxiong10/vue2-datepicker/commit/4ff6945))
- show the popup on focus and close it on blur ([3bcedf5](https://github.com/mengxiong10/vue2-datepicker/commit/3bcedf5))

## [2.9.2](https://github.com/mengxiong10/vue2-datepicker/compare/v2.9.1...v2.9.2) (2019-02-10)

### Bug Fixes

- the display error of the year panel header ([#245](https://github.com/mengxiong10/vue2-datepicker/issues/245)) ([7bc2785](https://github.com/mengxiong10/vue2-datepicker/commit/7bc2785))

## [2.9.1](https://github.com/mengxiong10/vue2-datepicker/compare/v2.9.0...v2.9.1) (2019-02-01)

### Bug Fixes

- stringify function returns a error value,when date is null ([#244](https://github.com/mengxiong10/vue2-datepicker/issues/244)) ([92243ab](https://github.com/mengxiong10/vue2-datepicker/commit/92243ab))

# [2.9.0](https://github.com/mengxiong10/vue2-datepicker/compare/v2.8.1...v2.9.0) (2019-01-29)

### Features

- support custom format function ([c801516](https://github.com/mengxiong10/vue2-datepicker/commit/c801516))

## [2.8.1](https://github.com/mengxiong10/vue2-datepicker/compare/v2.8.0...v2.8.1) (2019-01-24)

### Bug Fixes

- clickoutside event listener change capturing to bubbling ([054758e](https://github.com/mengxiong10/vue2-datepicker/commit/054758e))
- use refs instead of children array ([f43e3a3](https://github.com/mengxiong10/vue2-datepicker/commit/f43e3a3))

# [2.8.0](https://github.com/mengxiong10/vue2-datepicker/compare/v2.7.0...v2.8.0) (2019-01-13)

### Features

- add `valueType` to format binding value ([dd6f2ea](https://github.com/mengxiong10/vue2-datepicker/commit/dd6f2ea))

# [2.7.0](https://github.com/mengxiong10/vue2-datepicker/compare/v2.6.3...v2.7.0) (2019-01-08)

### Bug Fixes

- when clear input(not use clear button) the date value not changed ([39d2c40](https://github.com/mengxiong10/vue2-datepicker/commit/39d2c40))

### Features

- add class to .mx-calendar indicating the different panel ([#219](https://github.com/mengxiong10/vue2-datepicker/issues/219)) ([1d0a67b](https://github.com/mengxiong10/vue2-datepicker/commit/1d0a67b))
- add prop inputAttr ([2381089](https://github.com/mengxiong10/vue2-datepicker/commit/2381089))

## [2.6.4](https://github.com/mengxiong10/vue2-datepicker/compare/v2.6.3...v2.6.4) (2018-12-19)

### Bug Fixes

- when clear input(not use clear button) the date value not changed ([39d2c40](https://github.com/mengxiong10/vue2-datepicker/commit/39d2c40))

## [2.6.3](https://github.com/mengxiong10/vue2-datepicker/compare/v2.6.2...v2.6.3) (2018-12-08)

### Bug Fixes

- fix unable set value later when range is ture ([#209](https://github.com/mengxiong10/vue2-datepicker/issues/209)) ([97289d1](https://github.com/mengxiong10/vue2-datepicker/commit/97289d1))

## [2.6.2](https://github.com/mengxiong10/vue2-datepicker/compare/v2.6.1...v2.6.2) (2018-10-30)

### Bug Fixes

- `calendar-change` trigger in right time ([b1a5a41](https://github.com/mengxiong10/vue2-datepicker/commit/b1a5a41))

### Features

- add `calendar-change` event ([ef9314e](https://github.com/mengxiong10/vue2-datepicker/commit/ef9314e))

## [2.6.1](https://github.com/mengxiong10/vue2-datepicker/compare/v2.6.0...v2.6.1) (2018-10-17)

### Bug Fixes

- prevent popup internal click event from affecting the outside ([de177d8](https://github.com/mengxiong10/vue2-datepicker/commit/de177d8))

### Features

- when use script type, install automatic ([a310f59](https://github.com/mengxiong10/vue2-datepicker/commit/a310f59))

# [2.6.0](https://github.com/mengxiong10/vue2-datepicker/compare/v2.5.0...v2.6.0) (2018-10-11)

### Bug Fixes

- fix shortcut color ([ac4aa87](https://github.com/mengxiong10/vue2-datepicker/commit/ac4aa87))

### Features

- add prop `appendToBody` ([e26e1f5](https://github.com/mengxiong10/vue2-datepicker/commit/e26e1f5))

# [2.5.0](https://github.com/mengxiong10/vue2-datepicker/compare/v2.4.3...v2.5.0) (2018-10-05)

### Features

- add panel-change event ([5cdba7b](https://github.com/mengxiong10/vue2-datepicker/commit/5cdba7b))

## [2.4.3](https://github.com/mengxiong10/vue2-datepicker/compare/v2.4.0...v2.4.3) (2018-09-28)

### Bug Fixes

- fix the selectTime 'am' and 'pm' ([8e475b3](https://github.com/mengxiong10/vue2-datepicker/commit/8e475b3))
- IE compatibility ([fefed17](https://github.com/mengxiong10/vue2-datepicker/commit/fefed17))
- timeType default ([38a657b](https://github.com/mengxiong10/vue2-datepicker/commit/38a657b))
- when select time picker option close popup ([#154](https://github.com/mengxiong10/vue2-datepicker/issues/154)) ([12907ad](https://github.com/mengxiong10/vue2-datepicker/commit/12907ad))
- year and month disable don't right ([#169](https://github.com/mengxiong10/vue2-datepicker/issues/169)) ([42bc068](https://github.com/mengxiong10/vue2-datepicker/commit/42bc068))

### Features

- emit `clear` event for the clear button ([e0776b6](https://github.com/mengxiong10/vue2-datepicker/commit/e0776b6))

# [2.4.0](https://github.com/mengxiong10/vue2-datepicker/compare/v2.3.2...v2.4.0) (2018-08-08)

### Features

- add prop `time` to show only time picker ([1046731](https://github.com/mengxiong10/vue2-datepicker/commit/1046731))

## [2.3.2](https://github.com/mengxiong10/vue2-datepicker/compare/v2.2.0...v2.3.2) (2018-08-07)

### Features

- add prop `date-format` ([3c27647](https://github.com/mengxiong10/vue2-datepicker/commit/3c27647))

# [2.2.0](https://github.com/mengxiong10/vue2-datepicker/compare/v2.1.0...v2.2.0) (2018-08-06)

### Bug Fixes

- set input autocomplete off ([264458c](https://github.com/mengxiong10/vue2-datepicker/commit/264458c))

### Features

- add event 'change-calendar-year' 'change-calendar-month' ([bc80708](https://github.com/mengxiong10/vue2-datepicker/commit/bc80708))

# [2.1.0](https://github.com/mengxiong10/vue2-datepicker/compare/v2.0.0...v2.1.0) (2018-07-24)

### Bug Fixes

- fecha.format need a date ([1e54efc](https://github.com/mengxiong10/vue2-datepicker/commit/1e54efc))
- shortcut date changed to function ([5cf6c72](https://github.com/mengxiong10/vue2-datepicker/commit/5cf6c72))

### Features

- add the slot footer slot-scope to confirm event ([43d9fd7](https://github.com/mengxiong10/vue2-datepicker/commit/43d9fd7))
- export the fecha to use ([ac958d4](https://github.com/mengxiong10/vue2-datepicker/commit/ac958d4))

# [2.0.0](https://github.com/mengxiong10/vue2-datepicker/compare/9df1fe0...v2.0.0) (2018-06-16)

### Features

- Add `clearable` used to show clear icon
- Add slot `calendar-icon` to custom calendar icon
- Add slot `header` and `footer` to custom popup area
- `disabledDays` supports custom functions

### Breaking changes

- Refactored code. This may fail if you hacked the code
- `format` default value changes from yyyy-MM-dd to YYYY-MM-DD, now the parsing tokens are similar to the moment.js, not supports lowercase yyyy
- remove `custom-formatter`
- `editable` default value changes from false to true, now supports range
- select the year or month panel will not change the value(Because it causes many problems when set the `not-before` or `not-after`)
