<?php
    $favicon = config("app.favicon");
?>
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <script>
        'use strict';
        window.settings = {
            app_link: "<?php echo e(url('/')); ?>",
            csrfToken: "<?php echo e(csrf_token()); ?>",
            
            logged_in: "<?php echo e((session('slack') != '')?1:0); ?>",
            logged_in_user: "<?php echo e(session('slack')); ?>",
            access_token: "<?php echo e(session('access_token')); ?>",
            logged_user_store_slack: "<?php echo e((isset($logged_user_data['selected_store']['store_slack']))?$logged_user_data['selected_store']['store_slack']:''); ?>",
            
            language: "<?php echo e((isset($logged_user_data['selected_language_code']))?$logged_user_data['selected_language_code']:(isset($language)?$language:'en')); ?>",
            menu_language: "<?php echo e(isset($language)?$language:''); ?>",

            restaurant_mode: "<?php echo e((isset($logged_user_data['selected_store']['restaurant_mode']))?$logged_user_data['selected_store']['restaurant_mode']:0); ?>",
            currency_code: "<?php echo e((isset($logged_user_data['selected_store']['currency_code']))?$logged_user_data['selected_store']['currency_code']:''); ?>"
        }
    </script>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no, user-scalable=no">
    
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e($favicon); ?>">
    <link rel="apple-touch-icon" href="<?php echo e(asset('images/logo_apple_touch_icon.png')); ?>"/>
    
    <link rel="stylesheet" href="<?php echo e(asset('css/font.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('plugins/bootstrap/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables/datatables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables/dataTables.bootstrap4.min.css')); ?>"> 
    <link rel="stylesheet" href="<?php echo e(asset('plugins/fontawesome/all.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/web.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/nav.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/tables.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/form.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/button.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/labels.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/modal.css')); ?>">
    <?php echo $__env->yieldPushContent('styles'); ?>
    <title><?php echo e((config('app.app_title'))?config('app.app_title'):'Appsthing POS'); ?></title>
</head><?php /**PATH /home/stemvimc/ka.stemvim.co.ke/resources/views/layouts/header.blade.php ENDPATH**/ ?>